`timescale 100ps / 10ps

/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE

module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
	reg SI_IO0_reg=0;
  reg SO_IO1_reg=0;
  reg WPn_IO2_reg=0;
  reg IO3_reg=0;

  reg [3:0] tx;
  reg sel_dev;

  parameter SPI = 3'h1;
  parameter DPI = 3'h2;
  parameter QPI = 3'h4;

  wire SI_IO0;
  wire SO_IO1;
  wire WPn_IO2;
  wire IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  `include "task.v"
  
  assign IO[0] = (tx[0] && sel_dev==1'b0) ? SI_IO0_reg : 1'bz;  
  assign IO[1] = (tx[1] && sel_dev==1'b0) ? SO_IO1_reg : 1'bz;  
  assign IO[2] = (tx[2] && sel_dev==1'b0) ? WPn_IO2_reg : 1'bz;  
  assign IO[3] = (tx[3] && sel_dev==1'b0) ? IO3_reg : 1'bz;  
  assign IO[4] = (tx[0] && sel_dev==1'b1) ? SI_IO0_reg : 1'bz;  
  assign IO[5] = (tx[1] && sel_dev==1'b1) ? SO_IO1_reg : 1'bz;  
  assign IO[6] = (tx[2] && sel_dev==1'b1) ? WPn_IO2_reg : 1'bz;  
  assign IO[7] = (tx[3] && sel_dev==1'b1) ? IO3_reg : 1'bz;  
  assign CLK1 = (sel_dev==1'b0) ? CLK : 0;
  assign CLK2 = (sel_dev==1'b1) ? CLK : 0;
  assign CS1n = (sel_dev==1'b0) ? CSn : 1'b1;
  assign CS2n = (sel_dev==1'b1) ? CSn : 1'b1;

  assign SI_IO0  = (sel_dev == 1'b0) ? IO[0] : IO[4];
  assign SO_IO1  = (sel_dev == 1'b0) ? IO[1] : IO[5];
  assign WPn_IO2 = (sel_dev == 1'b0) ? IO[2] : IO[6];
  assign IO3     = (sel_dev == 1'b0) ? IO[3] : IO[7];

  /* Initialize */
  initial begin
    SI_IO0_reg = 0;
    SO_IO1_reg = 0;
    WPn_IO2_reg = 0;
    IO3_reg = 0;
    tx = 0;
  end

  initial begin
    tx = 4'd0;
    sel_dev = 0;
    #10000;

    $display("==== [TEST] Read ID ====");
    ReadID();
    
    $display("==== [TEST] Status Register Check ====");
    WriteEnable(SPI);
    WriteStatus(SPI, 8'hAA);
    ReadStatus(SPI, 8'hAA);
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    ReadStatus(SPI, 8'h00);

    $display("==== [TEST] Config Register Check ====");
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'hAA);
    ReadReg(SPI, ADDR_CR1, 8'hAA, 8'd0);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01);
    ReadReg(SPI, ADDR_CR1, 8'h01, 8'd0);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'hAA);
    ReadReg(SPI, ADDR_CR2, 8'hAA, 8'hA);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h08);
    ReadReg(SPI, ADDR_CR2, 8'h08, 8'h8);

    $display("==== [TEST] Memory Write Read Check ====");
    WriteEnable(SPI);
    WriteSeq(SPI, 32'habcd, 8'h16, 8'h7, 24'd10);
    ReadSeq(SPI, 32'habcd, 8'h16, 8'h7, 24'd10);
    $finish;
  end
endmodule
